RabbitMQ Queue driver for (Laravel/Lumen)
======================

لطفا کد زیر را به فایل composer.json پروژه اضافه کنید:

```json
{
    "repositories": [
        {
            "type": "git",
            "url": "https://git.greenweb.ir/iranserver-sdk/rabbitmq-package.git"
        }
    ]
}
```

سپس اقدام به نصب پکیج کنید:

```
composer require iranserver/rabbitmq-package
```

پس از اتمام نصب در صورتی که از lumen استفاده میکنید، کد زیر را در فایل bootstrap/app.php اضافه کنید:

```php
$app->register(Iranserver\RabbitMQ\RabbitMQServiceProvider::class);
```

برای شروع حداقل به تنظیمات زیر نیاز دارید:

```
QUEUE_CONNECTION=rabbitmq
RABBITMQ_QUEUE=test
RABBITMQ_HOST=some-rabbit
RABBITMQ_USER=test
RABBITMQ_PASSWORD=test
RABBITMQ_EXCHANGE=test-exchange
RABBITMQ_EXCHANGE_TYPE=fanout
```

پابلیش کردن جداول queue
```php
php artisan queue:table
```

روش اجرای صف:

```php
php artisan rabbitmq:consume      # ~2x More performant.
#OR
php artisan queue:work
```
 روش اجرا کردن صف دیتابیس با queue مشخص
```php
php artisan queue:work database --queue=test
```
-------------------------
### Start dispatching jobs

اگر پکیج `Iranserver\Basics` رو نصب کرده باشید، جاب های لازم درون پوشه `app/jobs` شما وجود دارد و فقط باید از آن استفاده نمود.

برای dispatch کردن job تنها لازم است روش زیر را اجرا کنید:
```php
dispatch(new ExampleJob( /** Variable that you have to pass */ ));
```
###### ** توجه کنید که job namespace شما باید در`app/jobs` باشه نه در `Iranserver\Basics`

-------------------------

### Job with retries

اگر لازم دارید یک Job به تعداد باز خاصی اجرا بشه و بعد Fail بشه باید از روش زیر استفاده کنید:

```php
<?php

namespace App\Jobs\Example;

use Iranserver\Basics\Jobs\Base\ExampleJob as BaseJob;

class ExampleJob extends BaseJob
{
    /** 
     *  This means that job will try 5 times if exception occurred
     */
    public $tries = 5;

    public function handle()
    {
      // handle whatever you want
    }
}
```

### Job backoff

اگر لازم دارید یک Job پس از fail شدن با تاخیر دوباره اجرا شود باید از روش پارامتر زیر در job خود استفاده کنید:

```php
    public $backoff = /** Number of second that job backoff */;
```

-------------------------

### Rollback time

اگر شما چیزی را میخواهید rollback کنید و job شما نیازی به retry ندارد تنها کاری که لازم است انجام دهید مانند مثال زیر است:

```php
<?php

namespace App\Jobs\Example;

use Iranserver\Basics\Jobs\Base\ExampleJob as BaseJob;

class ExampleJob extends BaseJob
{
    public function handle()
    {
      try {
            // do whatever you want to do
         }
         catch (\Exception $exception)
         {
            /** 
             * if exception occurred Dispatch rollback job
             */
              dispatch(new RollbackJob($exception));
              
              // throw new exception to fail the job
              throw new \Exception($exception);
         }
    }
}
```

### Rollback with retry

اگر شما چیزی را میخواهید rollback کنید و job شما retry دارد تنها کاری که لازم است انجام دهید مانند مثال زیر است:

```php
<?php

namespace App\Jobs\Example;

use Iranserver\Basics\Jobs\Base\ExampleJob as BaseJob;

class ExampleJob extends BaseJob
{
    /** 
     *  This means that job will try 5 times if exception occurred
     */
    public $tries = 5;
    
    public function handle()
    {
      try {
            // do whatever you want to do
         }
         catch (\Exception $exception)
         {
            /** 
             * if job maximum retry executed rollback
             */
             if ($this->shouldRollBack()){
                dispatch(new RollbackJob($exception));
             }
              
              // throw new exception to fail the job or retry
              throw new \Exception($exception);
             
         }
    }
}
```
در سناریو بالا این job اگر به خطا بخوره تا 5 بار retry میشه و سپس در آخر dispatch RollbackJob میشه 

###### ** توجه کنید که job های fail شده به صورت پیشفرض نیازه که در database ذخیره شوند برای همین دستور زیر برای ساخت  faild-queue table migration الزامی هستش

پابلیش کردن جداول failed queue
```php
php artisan queue:failed-table
```

در لینک [زیر](https://laravel.com/docs/9.x/queues) میتونید اطلاعات بیشتری درمورد job های laravel پیدا کنید

-------------------------

### Failing job

اگر لازم دارید تا یک job رو fail کنید و اجرا نشه حتی با اینکه retry داره باید از متود زیر استفاده کنید:

```php
$this->fail(/** exception */);
```
