<?php

namespace Iranserver\RabbitMQ;

use Illuminate\Console\Events\CommandStarting;
use Illuminate\Queue\QueueManager;
use VladimirYuldashev\LaravelQueueRabbitMQ\LaravelQueueRabbitMQServiceProvider;

class RabbitMQServiceProvider extends LaravelQueueRabbitMQServiceProvider
{
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__ . "/../config/rabbitmq.php", 'queue.connections.rabbitmq');

        parent::register();

        $this->app['events']->listen(CommandStarting::class, function (CommandStarting $event) {

            if (in_array($event->command,["rabbitmq:consume","queue:work"])) {

                $binding      = config('queue.connections.rabbitmq.binding-keys');
                $exchange     = config('queue.connections.rabbitmq.options.queue.exchange');
                $exchangeType = config('queue.connections.rabbitmq.options.queue.exchange_type');
                $queueType    = config('queue.connections.rabbitmq.options.queue.queue_type');

                /**
                 * @var QueueManager $queue
                 * @var RabbitMQQueue $rabbitmq
                 */
                $queue    = $this->app['queue'];
                $rabbitmq = $queue->connection('rabbitmq');

                /*
                |--------------------------------------------------------------------------
                | declare exchange
                |--------------------------------------------------------------------------
                */
                if (!$rabbitmq->isExchangeExists($exchange)) {
                    $rabbitmq->declareExchange($exchange,$exchangeType);
                }

                /*
                |--------------------------------------------------------------------------
                | declare queue
                |--------------------------------------------------------------------------
                */
                foreach ($binding as $item) {
                    foreach ($item['to-binding-key'] as $bindingKey) {
                        if (!$rabbitmq->isQueueExists($item['queue']))
                            $rabbitmq->declareQueue($item['queue'], true, false,[
                                'x-queue-type' => $queueType
                            ]);
                        $rabbitmq->bindQueue($item['queue'], $exchange, $bindingKey);
                    }
                }
            }
        });
    }
}
