<?php

namespace Iranserver\RabbitMQ;

use Exception;
use Iranserver\Jobs\AutoResolver\BaseResolverJob;
use ReflectionClass;
use ReflectionProperty;
use VladimirYuldashev\LaravelQueueRabbitMQ\Queue\RabbitMQQueue as BaseRabbitMQQueue;
use PhpAmqpLib\Exception\AMQPChannelClosedException;
use PhpAmqpLib\Exception\AMQPConnectionClosedException;

class RabbitMQQueue extends BaseRabbitMQQueue
{
    public function push($job, $data = '', $queue = null)
    {
        [$job, $queue] = $this->getDependentJob($job, $queue);
        return parent::push($job, $data, $queue);
    }

    protected function getDependentJob($job, $queue) : array
    {
        $class = new ReflectionClass($job);

        foreach ($class->getAttributes(AutoResolve::class) as $attribute) {
            $args = $attribute->getArguments();

            // Get needed properties?
            $property = $this->getPropertyValue($class, $args[0]);
            $related = $this->getPropertyValue($class, $args[1]);

            // Is property filled?
            if (!is_null($property->getValue($job))) continue;

            // Does the property have an interface type?
            $interfaceName = $property->getType()?->getName();
            if (!interface_exists($interfaceName)) {
                throw new Exception(sprintf("The property type should be an object, %s given.", $interfaceName));
            }

            // Does the interface have a resolver?
            $interface = new ReflectionClass($interfaceName);
            $resolveBy = $interface->getAttributes(ResolveBy::class);
            if (!$resolveBy) {
                throw new Exception(sprintf("the resolve-by flag is not available for interface %s.", $interfaceName));
            }

            // Dispatch resolver
            $resolveByClass = $resolveBy[0]->getArguments()[0];
            $routKey = $resolveBy[0]->getArguments()[1];

            $related = $related->getValue($job);
            $this->generateClass($resolveByClass, BaseResolverJob::class);
            $new = new $resolveByClass($args[0], data_get($related, $args[2] ?? "{$args[0]}_id"), $job);
            $new->onQueue($routKey);

            return [$new, $new->queue];
        }

        return [$job, $queue];
    }

    protected function getPropertyValue($class, $propertyName) : ReflectionProperty
    {
        if (!$class->hasProperty($propertyName)) {
            throw new Exception(sprintf("Property does not exists: [%s].", $propertyName));
        }

        $property = $class->getProperty($propertyName);
        $property->setAccessible(true);
        return $property;
    }

    protected function generateClass($classname, $extends)
    {
        if (!class_exists($classname)) {
            $base = class_basename($classname);
            $namespace = substr($classname, 0, -strlen($base) - 1);
            eval("namespace $namespace {
                class $base extends \\$extends {
                    public function resource(\$resourceId)
                    {
                    }
                }
            }");
        }
    }

    protected function publishBasic($msg, $exchange = '', $destination = '', $mandatory = false, $immediate = false, $ticket = null): void
    {
        try {
            parent::publishBasic($msg, $exchange, $destination, $mandatory, $immediate, $ticket);
        } catch (AMQPConnectionClosedException $e) {
            $this->reconnect();
            parent::publishBasic($msg, $exchange, $destination, $mandatory, $immediate, $ticket);
        } catch (AMQPChannelClosedException $e) {
            $this->reconnect();
            parent::publishBasic($msg, $exchange, $destination, $mandatory, $immediate, $ticket);
        }
    }
}