<?php

namespace Iranserver\RabbitMQ;

use Illuminate\Queue\Jobs\JobName;
use Illuminate\Support\Facades\Log;
use VladimirYuldashev\LaravelQueueRabbitMQ\Queue\Jobs\RabbitMQJob as BaseRabbitMQJob;

class RabbitMQJob extends BaseRabbitMQJob
{
    public function fire()
    {
        $payload = $this->payload();
        [$class, $method] = JobName::parse($payload['job']);
        $commandName = $payload['displayName'];

        if (@ class_exists($commandName)) {

            if (explode('\\', $commandName)[1] == "Events") {
                app('events')->dispatch(unserialize($payload['data']['command']));
                $this->delete();

            } else {
                ($this->instance = $this->resolve($class))->{$method}($this, $payload['data']);
            }

        } else {

            $this->delete();
        }
    }
}
