<?php

namespace Iranserver\RabbitMQ;

use Illuminate\Queue\Jobs\JobName;
use VladimirYuldashev\LaravelQueueRabbitMQ\Queue\Jobs\RabbitMQJob as BaseRabbitMQJob;

class RabbitMQJob extends BaseRabbitMQJob
{
    public function fire()
    {
        $payload = $this->payload();
        [$class, $method] = JobName::parse($payload['job']);

        if (@ class_exists($payload['displayName']))
            if (explode('\\' , $payload['displayName'])[1]  == "Events") {
                app('events')->dispatch(unserialize($payload['data']['command']));
            } else{
                ($this->instance = $this->resolve($class))->{$method}($this, $payload['data']);
            }
        else
            $this->delete();
    }
}
