<?php

return [
    'driver'     => 'rabbitmq',
    'queue'      => env('RABBITMQ_QUEUE', 'default'),
    'connection' => PhpAmqpLib\Connection\AMQPLazyConnection::class,

    'hosts' => [
        [
            'host'     => env('RABBITMQ_HOST', '127.0.0.1'),
            'port'     => env('RABBITMQ_PORT', 5672),
            'user'     => env('RABBITMQ_USER', 'guest'),
            'password' => env('RABBITMQ_PASSWORD', 'guest'),
            'vhost'    => env('RABBITMQ_VHOST', '/'),
        ],
    ],

    'options' => [
        'ssl_options' => [
            'cafile'      => env('RABBITMQ_SSL_CAFILE'),
            'local_cert'  => env('RABBITMQ_SSL_LOCALCERT'),
            'local_key'   => env('RABBITMQ_SSL_LOCALKEY'),
            'verify_peer' => env('RABBITMQ_SSL_VERIFY_PEER', true),
            'passphrase'  => env('RABBITMQ_SSL_PASSPHRASE'),
        ],
        'queue'       => [
            'job'                  => Iranserver\RabbitMQ\RabbitMQJob::class,
            'queue_type'           => env('RABBITMQ_QUEUE_TYPE','classic'),
            'exchange'             => env('RABBITMQ_EXCHANGE','master-exchange'),
            'exchange_type'        => env('RABBITMQ_EXCHANGE_TYPE','topic'),
            'exchange_routing_key' => env('RABBITMQ_EXCHANGE_ROUTE_KEY'),
        ],
    ],

    'binding-keys' => [
        //[
        //    'queue' => 'service_queue',
        //    'to-binding-key' => [
        //        'sms.event.cancel',
        //        'single.event.send'
        //    ]
        //]
    ],

    /*
     * Set to "horizon" if you wish to use Laravel Horizon.
     */
    'worker'  => Iranserver\RabbitMQ\RabbitMQQueue::class
];
