<?php

namespace Iranserver\RabbitMQ;

use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobQueued;
use Illuminate\Queue\QueueManager;
use Illuminate\Support\Facades\Log;
use PhpAmqpLib\Exchange\AMQPExchangeType;
use VladimirYuldashev\LaravelQueueRabbitMQ\LaravelQueueRabbitMQServiceProvider;
use VladimirYuldashev\LaravelQueueRabbitMQ\Console\ConsumeCommand;
class RabbitMQServiceProvider extends LaravelQueueRabbitMQServiceProvider
{
    public function register(): void
    {
        $this->mergeConfigFrom(__DIR__ . "/../config/rabbitmq.php", 'queue.connections.rabbitmq');

        /*
        |--------------------------------------------------------------------------
        | register application and when queue:work or rabbitmq:consume
        |--------------------------------------------------------------------------
        */
        parent::register();

        $this->app->singleton(ConsumeCommand::class, static function ($app) {

            /*
            |--------------------------------------------------------------------------
            | initial config
            |--------------------------------------------------------------------------
            */
            $binding      = config('queue.connections.rabbitmq.binding-keys');
            $exchange     = config('queue.connections.rabbitmq.options.queue.exchange');
            $exchangeType = config('queue.connections.rabbitmq.options.queue.exchange_type');
            $queueType    = config('queue.connections.rabbitmq.options.queue.queue_type');
            /**
             * @var QueueManager $queue
             * @var RabbitMQQueue $rabbitmq
             */
            $queue    = $app['queue'];
            $rabbitmq = $queue->connection('rabbitmq');

            /*
            |--------------------------------------------------------------------------
            | declare exchange
            |--------------------------------------------------------------------------
            */
            if (!$rabbitmq->isExchangeExists($exchange)) {
                $rabbitmq->declareExchange($exchange,$exchangeType);
            }

            /*
            |--------------------------------------------------------------------------
            | declare queue
            |--------------------------------------------------------------------------
            */
            foreach ($binding as $item) {
                foreach ($item['to-binding-key'] as $bindingKey) {
                    if (!$rabbitmq->isQueueExists($item['queue']))
                        $rabbitmq->declareQueue($item['queue'], true, false,[
                            'x-queue-type' => $queueType
                        ]);
                    $rabbitmq->bindQueue($item['queue'], $exchange, $bindingKey);
                }
            }

            return new ConsumeCommand(
                $app['rabbitmq.consumer'],
                $app['cache.store']
            );
        });
    }

    public function boot(): void
    {
        parent::boot();
    }
}
