<?php

namespace Iranserver\Models\Interfaces;

use Iranserver\Models\Enums\UserStatusEnum;
use Iranserver\RabbitMQ\ResolveBy;

/**
 * @property int $id
 * @property string $email
 * @property string $password bcrypt
 * @property string $first_name
 * @property string $last_name
 * @property string $company
 * @property UserStatusEnum $status
 * @property ContactInterface[] $contacts
 * @property ClientInterface[] $clients
 * @property string $created_at
 * @property string $updated_at
 */
#[ResolveBy('App\Jobs\ResolveUserJob','user.cmd.resolve')]
interface UserInterface{}