<?php

namespace Iranserver\Models\Interfaces;

use Carbon\Carbon;
use Iranserver\Models\Enums\AutoTerminateStatusEnum;
use Iranserver\Models\Enums\ServiceStatusEnum;
use Iranserver\Models\Base\Product;
use Iranserver\RabbitMQ\ResolveBy;

/**
 * @property integer $id
 * @property integer $user_id
 * @property integer $service_id // hosting id or hosting addon id
 * @property integer $reference_id //product id or addon id
 * @property string $reference_type // Product or Addon
 * @property string $name
 * @property string $domain
 * @property AutoTerminateStatusEnum $auto_terminate
 * @property ServiceStatusEnum $status
 * @property Carbon $next_due_date
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @property-read Product product
 */
#[ResolveBy('App\Jobs\ResolveServiceJob','service.cmd.resolve')]
interface ServiceInterface
{

}