<?php

namespace Iranserver\Models\Interfaces;

use Carbon\Carbon;
use Iranserver\Models\Enums\AutoTerminateStatusEnum;
use Iranserver\Models\Enums\ServiceStatusEnum;
use Iranserver\Models\Base\Product;
use Iranserver\RabbitMQ\ResolveBy;

/**
 * @property integer $id
 * @property integer $user_id
 * @property integer $reference_id
 * @property string $reference_type
 * @property string $name
 * @property integer $product_id
 * @property string $domain
 * @property AutoTerminateStatusEnum $auto_terminate
 * @property ServiceStatusEnum $status
 * @property Carbon $next_due_date
 * @property Carbon $created_at
 * @property Carbon $updated_at
 *
 * @property-read Product product
 */
#[ResolveBy('App\Jobs\ResolveServiceJob','service.cmd.resolve')]
interface ServiceInterface
{

}