Laravel Metrics (Laravel/Lumen)
======================

# نصب:

لطفا کد زیر را به فایل `composer.json` پروژه اضافه کنید:

```json
{
    "repositories": [
        {
            "type": "git",
            "url": "https://git.greenweb.ir/iranserver-sdk/laravel-metrics.git"
        }
    ]
}
```

سپس اقدام به نصب پکیج کنید:

```
composer require iranserver/laravel-metrics
```

پس از اتمام نصب در صورتی که از `lumen` استفاده میکنید، کد زیر را در فایل `bootstrap/app.php` اضافه کنید:

```php
$app->register(Iranserver\Metrics\MetricsServiceProvider::class);
```

# نحوه استفاده:

```php
$counter = Metrics::getOrRegisterCounter('application', 'some_counter', 'it increases', ['type']);
$counter->incBy(3, ['blue']);

$gauge = Metrics::getOrRegisterGauge('application', 'some_gauge', 'it sets', ['type']);
$gauge->set(rand(1, 5), ['blue']);

$histogram = Metrics::getOrRegisterHistogram('application', 'some_histogram', 'it observes', ['type'], [0.1, 1, 2, 3.5, 4, 5, 6, 7, 8, 9]);
$histogram->observe(3.5, ['blue']);

$summary = Metrics::getOrRegisterSummary('application', 'some_summary', 'it observes a sliding window', ['type'], 84600, [0.01, 0.05, 0.5, 0.95, 0.99]);
$summary->observe(5, ['blue']);
```

استفاده به عنوان listener:

```
php artisan make:metric SomeMetric
```

```php
class EventServiceProvider extends ServiceProvider
{
    protected $listen = [
        MetricRouteEvent::class => [
            SomeMetric::class
        ]
    ];
}
```