<?php

namespace Iranserver\Metrics;

use Prometheus\CollectorRegistry;
use Prometheus\RenderTextFormat;

trait MetricsMethod
{
    public function metrics(CollectorRegistry $registry)
    {
        event(new MetricRouteEvent());
        $renderer = new RenderTextFormat();
        $result = $renderer->render($registry->getMetricFamilySamples());
        return response($result)->header('Content-Type', 'text/plain');
    }
}