<?php

namespace Iranserver\Metrics;

use Illuminate\Support\Facades\Facade;
use Prometheus\CollectorRegistry;
use Prometheus\Counter;
use Prometheus\Gauge;
use Prometheus\Histogram;
use Prometheus\Summary;

/**
 * @method static void wipeStorage()
 * @method static Gauge getOrRegisterGauge(string $namespace, string $name, string $help, $labels = [])
 * @method static Counter getOrRegisterCounter(string $namespace, string $name, string $help, $labels = [])
 * @method static Histogram getOrRegisterHistogram(string $namespace, string $name, string $help, array $labels = [], array $buckets = null)
 * @method static Summary getOrRegisterSummary(string $namespace, string $name, string $help, array $labels = [], int $maxAgeSeconds = 600, array $quantiles = null)
 *
 * @see CollectorRegistry
 */
class Metrics extends Facade
{
    protected static function getFacadeAccessor()
    {
        return CollectorRegistry::class;
    }
}
