<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Tests\Feature;

use Illuminate\Support\Facades\Log;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Tests\JaravelTestCase;

class LoggingWhileTracingTest extends JaravelTestCase
{
    public function testLogsAddedWhenEnabledOption()
    {
        $tracer = $this->app->make(Tracer::class);
        $spanCreator = $this->app->make(SpanCreator::class);
        $spanCreator->create('Call MyService');

        Log::info('test log', ['context']);

        optional($tracer->getScopeManager()->getActive())
            ->close();
        $tracer->flush();

        $spans = $this->reporter->getSpans();
        $this->assertCount(1, $spans);
        $span = $spans[0];

        $this->assertCount(1, $span->getLogs());
        $this->assertSame([
            'message' => 'test log',
            'context' => ['context'],
            'level' => 'info',
        ], $span->getLogs()[0]['fields']);
    }
}
