<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services\Span;

use OpenTracing\Reference;
use OpenTracing\Span;
use OpenTracing\Tracer;

class SpanCreator
{
    private $tracer;

    public function __construct(Tracer $tracer)
    {
        $this->tracer = $tracer;
    }

    public function create(?string $operationName, ?Span $parentSpan = null, ?string $referenceType = null): Span
    {
        $span = $this->tracer->startSpan(
            $operationName ?? '',
            $this->detectSpanOptions($parentSpan, $referenceType)
        );

        $span->setTag('#env', env('APP_ENV', '---'));
        $span->setTag('#parent_id', $parentSpan ? sprintf('%x', $parentSpan->getContext()->getSpanId()) : '---');
        $span->setTag('#parent_title', $parentSpan ? $parentSpan->getOperationName() : '---');

        return $span;
    }

    private function detectSpanOptions(?Span $parentSpan, ?string $referenceType): array
    {
        $baseOptions = [
            'finish_span_on_close' => true,
        ];

        if (!$referenceType) {
            return $baseOptions;
        }

        return array_merge(
            $baseOptions,
            $parentSpan ? [
                'references' => new Reference($referenceType, $parentSpan->getContext()),
            ] : []
        );
    }
}
