<?php

namespace Iranserver\LaravelJaeger\Listeners\Query;

use Illuminate\Database\Events\QueryExecuted;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\ParentSpans;
use Iranserver\LaravelJaeger\Services\QueryTableFilter;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;
use OpenTracing\Reference;
use OpenTracing\Span;
use OpenTracing\Tracer;

final class QueryListener
{
    private $filter;
    private $tracer;
    private $spanCreator;

    public function __construct(QueryTableFilter $filter, Tracer $tracer, SpanCreator $spanCreator)
    {
        $this->filter = $filter;
        $this->tracer = $tracer;
        $this->spanCreator = $spanCreator;
    }

    /**
     * @throws CallerException
     */
    public function handle(QueryExecuted $event): void
    {
        if (!$this->filter->allow($event->sql)) {
            return;
        }

        /** @var Span|null $parentSpan */
        $parentSpan = ParentSpans::get();
        if (!$parentSpan) {
            return;
        }

        $span = $this->spanCreator->create(
            Caller::call(ConfigRepository::get('jaeger.query.span_name'), [$event]),
            $parentSpan,
            Reference::CHILD_OF
        );

        SpanTagHelper::setTags(
            $span,
            Caller::call(ConfigRepository::get('jaeger.query.tags'), [$event])
        );

        $span->finish();
        $this->tracer->flush();
    }
}
