<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners\Console;

use Illuminate\Console\Events\CommandFinished;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Span\ParentSpans;
use OpenTracing\Span;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\ConsoleCommandFilter;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;

final class ConsoleCommandFinishedListener
{
    private $filter;
    private $tracer;

    public function __construct(ConsoleCommandFilter $filter, Tracer $tracer)
    {
        $this->filter = $filter;
        $this->tracer = $tracer;
    }

    /**
     * @throws CallerException
     */
    public function handle(CommandFinished $event): void
    {
        if (!$this->filter->allow($event->command)) {
            return;
        }

        /** @var Span|null $consoleSpan */
        $consoleSpan = ParentSpans::get();
        if (!$consoleSpan) {
            return;
        }
        $spanName = Caller::call(ConfigRepository::get('jaeger.console.span_name'), [$event]);
        if ($consoleSpan->getOperationName() !== $spanName) {
            return;
        }

        SpanTagHelper::setTags(
            $consoleSpan,
            Caller::call(ConfigRepository::get('jaeger.console.tags'), [$event])
        );

        $consoleSpan->finish();
        $this->tracer->flush();

        ParentSpans::remove($consoleSpan);
    }
}
