<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Query;

use Illuminate\Database\Events\QueryExecuted;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class SpanNameResolver
{
    use JaegerFunctions;

    public function __invoke(QueryExecuted $event): string
    {
        $fullSql = $event->sql;
        foreach ($event->bindings as $binding) {
            $fullSql = preg_replace('/\?/', $this->jsonEncode($binding), $fullSql, 1);
        }
        return '[Query] ' . ($event->time ? '[' . round($event->time / 1000.0, 5) . '] ' : '') . $fullSql;
    }
}
