<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Job;

use Illuminate\Queue\Events\JobExceptionOccurred;
use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobProcessed;
use Illuminate\Queue\Events\JobProcessing;

final class SpanNameResolver
{
    /**
     * @param JobProcessing|JobProcessed|JobFailed|JobExceptionOccurred $event
     */
    public function __invoke($event): string
    {
        $job = $event->job;
        return '[Job] ' . '[Attempt ' . ($job->attempts() ?? 1) . ' Of ' . ($job->maxTries() ?? 1) . '] ' . $job->resolveName();
    }
}
