با استفاده از این ماژول میتوانید درخواست های خود را به صورت خودکار تریس کنید

## روش نصب 

برای استفاده از این پکیچ تنظیمات زیر را به فایل composer.json خود اضافه کنید.

```yaml
"repositories": [
    {
        "type": "composer",
        "url": "https://composer.staging.greentesting.ir"
    }
]
```

و نهایتا پکیج را نصب کنید.

```php
composer require iranserver/laravel-jaeger
```

برای شروع حداقل به تنظیمات زیر نیاز دارید:

```
JAEGER_TRACER_NAME=name-of-your-service
JAEGER_AGENT_HOST=jaeger-host
JAEGER_AGENT_PORT=jaeger-port (default: 6832)
```

### تنظیمات Laravel
در لاراول نیازی به انجام هیچ تنظیماتی نیست و Provider بصورت خودکار فعال میشود.

فقط لازم است فایل کانفیگ را پابلیش کنید.

```php
php artisan vendor:publish --tag=jaeger-config
```

### تنظیمات Lumen

در لومن برای فعال کردن provider باید در فایل `bootstrap/app.php` کد زیر را اضافه کنید.

```php
$app->configure('jaeger');
$app->register(\Iranserver\LaravelJaeger\LaravelJaegerServiceProvider::class);
```
و قطعه کد زیر را حتما از کامنت خارج کنید:
```php
$app->withFacades();
```
و فایل کانفیگ provider را از داخل vendor به مسیر config انتقال دهید.

## استفاده
این پکیج میتواند درخواست های Http, Console , درخواست های Guzzle به سرویس های دیگر و حتی Event های Queue را تریس کند.

شما می توانید تنظیمات خود را در jaeger.php تغییر دهید.
تمامی تنظیمات در زیر توضیح داده شدند.

شما میتوانید برای هرنوع Span, تنظیماتش را تغییر دهید:
```php
// config/jaeger.php
...
'http' => [
        'span_name' => function (Request $request) {
            return 'App: ' . $request->path();
        },
        'tags' => function (Request $request, Response $response) {
            return [
                'type' => 'http',
                'request_host' => $request->getHost(),
                'request_path' => $request->path(),
                'request_method' => $request->method(),
                'response_status' => $response->getStatusCode(),
                'error' => !$response->isSuccessful() && !$response->isRedirection(),
            ];
        },
    ],
...
    'guzzle' => [
        'span_name' => Iranserver\LaravelJaeger\Configurations\Guzzle\SpanNameResolver::class,
        'tags' => Iranserver\LaravelJaeger\Configurations\Guzzle\TagsResolver::class,
    ],
...
```

###  لاگ زدن query های دیتابیس

به صورت پیشفرض تمامی query های دیتابیس شما لاگ میشوند، با تنظیمات زیر میتوانید آن را خاموش کنید:

```
JAEGER_QUERY_LOGS=false
```


### تریس کردن درخواست های Http دریافتی

#### تنظیمات Laravel

برای تریس کردن درخواست های Http دریافتی, شما باید `Iranserver\LaravelJaeger\Middleware\HttpTracingMiddleware` Middleware را به روت هایی که میخواهید بدهید.

#### تنظیمات Lumen

در فایل `bootstrap/app.php` به Middleware های سراسری باید `HttpTracingMiddleware` را اضافه کنید:
```php
 $app->middleware([
     \Iranserver\LaravelJaeger\Middleware\HttpTracingMiddleware::class
 ]);
```

درخواست ها رو میشه با استفاده از `allow_request` و `deny_request` فیلتر کرد.

برای مثال اگه میخواهید فقط درخواست هایی با آدرس `api/` تریس شوند باید قطعه کد زیر را قرارد هید:
```php
// config/jaeger.php
...
'http' => [
        'allow_request' => function (Request $request) {
            return str_contains($request->path(), '/api');
        },
...
```

اگر `trace_id_header` کانفیگ شده باشه به Response یک header با محتوای trace id ارسال میشود.

### تریس کردن Console Commands

به صورت پیش فرض فعال است.

میتوانید با استفاده از `filter_commands` تریس کردن بعضی از `command` هارو غیرفعال کنید:
```php
// config/jaeger.php
...
'console' => [
        'filter_commands' => ['schedule:run'],
...
```

### تریس کردن Job ها
 
جاب ها به صورت خودکار تریس میشوند و نیاز به انجام کاری نیست!

-------------------------

پیشنهاد میشه که از trait `InteractsWithQueue` استفاده کنید تا بتونید از Method های Job هنگام Tag زدن استفاده کنید:

```php
// config/jaeger.php
...
'job' => [
    'tags' => fn ($realJob, ?Job $job) => [
        'type' => 'job',
        'job_class' => get_class($realJob),
        'job_id' => optional($job)
            ->getJobId(),
        'job_connection_name' => optional($job)
            ->getConnectionName(),
        'job_name' => optional($job)
            ->getName(),
        'job_queue' => optional($job)
            ->getQueue(),
        'job_attempts' => optional($job)
            ->attempts(),
    ],
],
...
```

### تریس کردن درخواست های خروجی با استفاده از Guzzle 

برای تریس کردن درخواست های Guzzle خود، فقط باید Middleware را به Guzzle Client خود اضافه کنید: 
```php
use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use Iranserver\LaravelJaeger\Services\Guzzle\HttpTracingMiddlewareFactory;

$this->app->bind(Client::class, function () {
    $stack = HandlerStack::create();
    $stack->push(HttpTracingMiddlewareFactory::create());
    return new Client(['handler' => $stack]);
});
```

> برای تریس کردن تمامی درخواست های Guzzle, شما باید تنظیمات بالا را توی Service Provider اضافه کنید 

### ساخت یک Span جدید

اگر شما نیاز دارید خودتون یک Span ایجاد کنید، راهنمای زیر رو مطالعه کنید:

```php
use App\Services\MyService;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;

// You should use dependency injection in your code, it`s just an example 
$spanCreator = app(SpanCreator::class);  

// First you need to create a span. It will be a child of current active span, if active span exists
$span = $spanCreator->create('Name of operation');

// Do something that you want to trace 
sleep(3);

// Close active scope (span will be finished automatically).
optional(app(Tracer::class)->getScopeManager()->getActive())->close();
```

### ساخت یک Trace جدید

اگر شما میخواهید قسمتی از برنامه خود را به صورت دستی Trace کنید، راهنمای زیر رو مطالعه فرمایید:
> فقط لازم است اطمینان داشته باشید که این قسمت از برنامه از قبل Trace نمیشود چون در انتها ما Trace رو میبندیم

```php
use App\Services\MyService;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;

// You should use dependency injection in your code, it`s just an example 
$spanCreator = app(SpanCreator::class);  

// First you need to create a span. It will be a child of current active span, if active span exists
$span = $spanCreator->create('Name of operation');

// Do something that you want to trace 
sleep(3);

// Close active scope (span will be finished automatically) and flush tracer.
optional(app(Tracer::class)->getScopeManager()->getActive())->close();
optional(app(Tracer::class))->flush();
```

اگر نیاز دارید تا traceId فعلی رو بگیرید با استفاده از دستور زیر میتوانید این کار را انجام دهید.
```php
(new \Iranserver\LaravelJaeger\Services\Span\ActiveSpanTraceIdRetriever(\OpenTracing\GlobalTracer::get()))->retrieve()
```

#### Tracing the hub

برای تریس کردن ماژول های هاب باید از زمانی که میخواهید تریس شروع شود از روش زیر استفاده کنید، پارامتر دوم `startActiveSpan` اختیاری هستش و اگه نیازی به تگ دارید استفاده کنید:

**معمولا شروع تریس کردن ماژول رو باید جایی مثل فایل اصلی ماژول قسمت output و clientarea گذاشت**

```php
startActiveSpan('Post: dashboard', [
            'tags'  =>  [
                'key'    =>  'Your tag value'
            ]
        ]);
```

برای تریس کردن درخواست های خارجی باید از روش زیر استفاده کنید ،پارامتر دوم `startActiveSpan` اختیاری هستش و اگه نیازی به تگ دارید استفاده کنید:
```php
$scope = startActiveSpan('Your request url', [
            'tags'  =>  [
                'key'    =>  'Your tag value'
            ]
        ]);
//If you want to log something in span just do this:
$scope->getSpan()->log(['Key' => 'Message to log']);

$headers = [];
/** if you want to send your trace id to next service you have to do this: otherwise it's not necessary */
tracerInject($scope->getSpan()->getContext(), $headers);

//trace id injected into $headers
$request = Request::post('www.example.com', $headers);

//You can even add extra tag after starting the span 
if ($request->code != 200) $scope->getSpan()->setTag('error', true);

//You have to finish the scope after getting response
$scope->close();

```

## Authors

Created by Iranserver.
