<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Str;

final class QueryTableFilter
{
    public function allow(string $sql): bool
    {
        $filteredTables = Config::get('jaeger.query.filter_tables', ['jobs']);
        $filteredTables = array_map(function ($tableName) {
            return "`$tableName`";
        }, $filteredTables);
        return !Str::contains($sql, $filteredTables);
    }
}
