<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services;

use Illuminate\Support\Facades\Config;
use Illuminate\Support\Str;

class ConsoleCommandFilter
{
    public function allow(string $command = null): bool
    {
        $filteredCommands = Config::get('jaeger.console.filter_commands', ['schedule:', 'horizon', 'queue:']);
        return !Str::contains($command, $filteredCommands);
    }
}
