<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners\Job;

use Illuminate\Queue\Events\JobProcessing;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\ParentSpans;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;
use OpenTracing\Reference;

final class JobStartedListener
{
    use JaegerFunctions;

    private $spanCreator;

    public function __construct(SpanCreator $spanCreator)
    {
        $this->spanCreator = $spanCreator;
    }

    /**
     * @throws CallerException
     */
    public function handle(JobProcessing $event): void
    {
        $payload = $event->job->payload();

        $this->loadParentSpans(isset($payload['jaeger']) ? $payload['jaeger'] : '');

        $span = $this->spanCreator->create(
            Caller::call(ConfigRepository::get('jaeger.job.span_name'), [$event]),
            ParentSpans::get(),
            Reference::CHILD_OF
        );

        ParentSpans::add($span);
    }
}
