<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\JobDispatcher;

use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(object $command): array
    {
        return [
            '#type'        => 'dispatcher',
            '-job_class'   => get_class($command),
            '-job_payload' => $this->jsonEncode($this->filterWordsInArray((array)$command)),
        ];
    }
}
