<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Job;

use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobProcessed;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    /**
     * @param JobProcessed|JobFailed $event
     */
    public function __invoke($event): array
    {
        return [
            '#type'            => 'job',
            '-class'           => $event->job->resolveName(),
            '-id'              => $event->job->getJobId(),
            '-connection_name' => $event->job->getConnectionName(),
            '-name'            => $event->job->getName(),
            '-queue'           => $event->job->getQueue(),
            '-attempts'        => $event->job->attempts(),
            '-error'           => $event->job->hasFailed(),
            '-payload'         => $this->jsonEncode($this->filterWordsInArray($event->job->payload())),
        ];
    }
}
