<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Http;

use Illuminate\Http\Request;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;
use Symfony\Component\HttpFoundation\Response;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(Request $request, Response $response): array
    {
        return [
            '#type'   => 'route',
            '-host'   => $request->getHost(),
            '-path'   => '/' . trim(trim($request->path()), '/'),
            '-method' => $request->method(),
            '-body'   => $this->jsonEncode($this->filterWordsInArray($request->all())),
            '-header' => $this->jsonEncode($this->filterWordsInArray($request->header())),
            '-status' => $response->getStatusCode(),
            '-error'  => !$response->isSuccessful() && !$response->isRedirection(),
        ];
    }
}
