<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Tests\Feature;

use GuzzleHttp\Client;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Psr7\Response;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Guzzle\HttpTracingMiddlewareFactory;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Tests\JaravelTestCase;

class GuzzleTracingTest extends JaravelTestCase
{
    public function testJobHandledWithInjection(): void
    {
        $mock = new MockHandler([new Response(200)]);

        $stack = HandlerStack::create($mock);
        $stack->push(HttpTracingMiddlewareFactory::create());
        $client = new Client([
            'handler' => $stack,
        ]);

        $spanCreator = app(SpanCreator::class);
        $tracer = $this->app->make(Tracer::class);
        $spanCreator->create('Call MyService');

        $client->request('GET', 'https://test.com');

        optional($tracer->getScopeManager()->getActive())
            ->close();
        $tracer->flush();

        $spans = array_reverse($this->reporter->getSpans());

        $this->assertCount(2, $spans);

        $serviceSpan = $spans[0];
        $guzzleSpan = $spans[1];

        $this->assertSame('Call MyService', $serviceSpan->getOperationName());
        $this->assertSame('request test.com', $guzzleSpan->getOperationName());

        $this->assertSame(
            $serviceSpan->getContext()->getSpanId(), $guzzleSpan->getContext()->getParentId()
        );
    }
}
