<?php

namespace Iranserver\LaravelJaeger\Traits;

use Illuminate\Support\Facades\Config;

trait JaegerFunctions
{
    private function jsonEncode($value): string
    {
        return json_encode($value, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    }

    private function filterValue(string $value, int $count = 3): string
    {
        $value = trim($value);
        $length = mb_strlen($value);
        $doubleCount = $count + $count;

        if ($length > $doubleCount) {
            $value = mb_substr($value, 0, $count) . str_repeat('-', $length - $doubleCount) . mb_substr($value, -$count);
        }

        return $value;
    }

    private function filterWordsInUrl(string $url): string
    {
        $filterWords = Config::get('jaeger.filter_words', []);

        parse_str((parse_url($url)['query'] ?? ''), $query);
        foreach ($query as $key => $value) {
            if (in_array($key, $filterWords) && !is_array($value)) {
                $query[$key] = $this->filterValue(strval($value));
            }
        }
        $query = http_build_query($query);

        return strtok($url, '?') . ($query != '' ? '?' . $query : '');
    }

    private function filterWordsInArray(array $array): array
    {
        $filterWords = Config::get('jaeger.filter_words', []);

        foreach ($array as $key => $value) {
            if (in_array($key, $filterWords) && !is_array($value)) {
                $array[$key] = $this->filterValue(strval($value));
            }
        }

        return $array;
    }
}