<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services\Http;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;

class TracingRequestGuard
{
    /**
     * @throws CallerException
     */
    public function allowRequest(Request $request): bool
    {
        if (!Caller::call(Config::get('jaeger.http.allow_request'), [$request], true)) {
            return false;
        }

        if (Caller::call(Config::get('jaeger.http.deny_request'), [$request], false)) {
            return false;
        }

        return true;
    }
}
