<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners\Job;

use Illuminate\Queue\Events\JobProcessing;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\TraceIdHeaderRetriever;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use OpenTracing\Reference;

final class JobStartedListener
{
    private $spanCreator;
    private $traceIdHeaderRetriever;

    public function __construct(TraceIdHeaderRetriever $traceIdHeaderRetriever, SpanCreator $spanCreator)
    {
        $this->traceIdHeaderRetriever = $traceIdHeaderRetriever;
        $this->spanCreator            = $spanCreator;
    }

    /**
     * @throws CallerException
     */
    public function handle(JobProcessing $event): void
    {
        $payload = $event->job->payload();

        $traceIdHeader = $this->traceIdHeaderRetriever->retrieve(
            isset($payload['jaegerTracingContext']) ? $payload['jaegerTracingContext'] : []
        );

        $this->spanCreator->create(
            Caller::call(ConfigRepository::get('jaeger.job.span_name'), [$event]),
            $traceIdHeader,
            Reference::CHILD_OF
        );
    }
}
