<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Query;

use Illuminate\Database\Events\QueryExecuted;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(QueryExecuted $event): array
    {
        $bindings = $this->filterWordsInArray($event->bindings);
        $fullSql = $event->sql;
        foreach ($bindings as $binding) {
            $fullSql = preg_replace('/\?/', $this->jsonEncode($binding), $fullSql, 1);
        }
        return [
            'type'                  => 'query',
            'query.sql'             => $event->sql,
            'query.sql_bindings'    => $this->jsonEncode($bindings),
            'query.sql_full'        => $fullSql,
            'query.connection_name' => $event->connectionName,
            'query.time'            => ($event->time ? round($event->time / 1000.0, 5) : null),
            'query.env'             => env('APP_ENV'),
        ];
    }
}
