<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\JobDispatcher;

use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(object $command): array
    {
        return [
            'type'                   => 'dispatcher',
            'dispatcher.job_class'   => get_class($command),
            'dispatcher.job_payload' => $this->jsonEncode($this->filterWordsInArray((array)$command)),
            'dispatcher.env'         => env('APP_ENV'),
        ];
    }
}
