<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Job;

use Illuminate\Queue\Events\JobFailed;
use Illuminate\Queue\Events\JobProcessed;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    /**
     * @param JobProcessed|JobFailed $event
     */
    public function __invoke($event): array
    {
        return [
            'type'                => 'job',
            'job.class'           => $event->job->resolveName(),
            'job.id'              => $event->job->getJobId(),
            'job.connection_name' => $event->job->getConnectionName(),
            'job.name'            => $event->job->getName(),
            'job.queue'           => $event->job->getQueue(),
            'job_attempts'        => $event->job->attempts(),
            'job.error'           => $event->job->hasFailed(),
            'job.payload'         => $this->jsonEncode($this->filterWordsInArray($event->job->payload())),
            'job.env'             => env('APP_ENV'),
        ];
    }
}
