<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Guzzle;

use Illuminate\Http\Client\Events\RequestSending;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(RequestSending $event): array
    {
        return [
            'type'          => 'guzzle',
            'guzzle.method' => $event->request->method(),
            'guzzle.url'    => $this->filterWordsInUrl($event->request->url()),
            'guzzle.body'   => $this->jsonEncode($this->filterWordsInArray($event->request->data())),
            'guzzle.header' => $this->jsonEncode($this->filterWordsInArray($event->request->headers())),
        ];
    }
}
