<?php

declare(strict_types=1);

use Iranserver\LaravelJaeger\Configurations;
use Iranserver\LaravelJaeger\Listeners;

return [

    /**
     * Enable JAEGER tracing or not. If not, noop tracer will be used.
     */
    'enabled' => env('JAEGER_ENABLED', true),

    /**
     * Name of your service, that will be shown in Jaeger panel
     */
    'tracer_name' => env('JAEGER_TRACER_NAME', 'application'),

    'agent_host' => env('JAEGER_AGENT_HOST', '127.0.0.1'),

    'agent_port' => env('JAEGER_AGENT_PORT', 6832),

    /**
     * Header name for trace`s id, that will be responded by TraceIdHttpHeaderMiddleware
     */
    'trace_id_header' => env('JAEGER_TRACE_ID_HEADER', 'x-trace-id'),

    /**
     * Every route in your application will be added as a new sub-span to active span, if enabled
     */
    'routes_enabled' => env('JAEGER_ROUTES_ENABLED', true),

    /**
     * Every log in your application will be added as a new sub-span to active span, if enabled
     */
    'logs_enabled' => env('JAEGER_LOGS_ENABLED', true),

    /**
     * Every query in your application will be added as a new sub-span to active span, if enabled
     */
    'query_logs' => env('JAEGER_QUERY_LOGS', true),

    /**
     * Every console command in your application will be added as a new sub-span to active span, if enabled
     */
    'console_enabled' => env('JAEGER_CONSOLE_ENABLED', true),

    /**
     * Every guzzle request in your application will be added as a new sub-span to active span, if enabled
     */
    'guzzle_enabled' => env('JAEGER_GUZZLE_ENABLED', true),

    /**
     * Every jobs that process in your application will be traced
     */
    'jobs_enabled' => env('JAEGER_JOBS_ENABLED', true),

    /**
     * Describes configuration for Log
     */
    'log' => [
        'listener'  => Listeners\Log\LogListener::class,
        'span_name' => Configurations\Log\SpanNameResolver::class,
        'tags'      => Configurations\Log\TagsResolver::class,
    ],

    /**
     * Describes configuration for Query
     */
    'query' => [
        'listener'  => Listeners\Query\QueryListener::class,
        'span_name' => Configurations\Query\SpanNameResolver::class,
        'tags'      => Configurations\Query\TagsResolver::class,
    ],

    /**
     * Describes configuration for Console commands
     */
    'console' => [
        'listener_started'  => Listeners\Console\ConsoleCommandStartedListener::class,
        'listener_finished' => Listeners\Console\ConsoleCommandFinishedListener::class,
        'span_name'         => Configurations\Console\SpanNameResolver::class,
        'tags'              => Configurations\Console\TagsResolver::class,
        'filter_commands'   => ['schedule:', 'horizon', 'queue:'],
    ],

    /**
     * Describes configuration for Guzzle requests
     */
    'guzzle' => [
        'listener'  => Listeners\Guzzle\GuzzleListener::class,
        'span_name' => Configurations\Guzzle\SpanNameResolver::class,
        'tags'      => Configurations\Guzzle\TagsResolver::class,
    ],

    /**
     * Describes configuration for Routes
     */
    'http' => [
        'span_name'     => Configurations\Http\SpanNameResolver::class,
        'tags'          => Configurations\Http\TagsResolver::class,
        'allow_request' => Configurations\Http\AllowRequestResolver::class,
        'deny_request'  => Configurations\Http\DenyRequestResolver::class,
    ],

    /**
     * Describes configuration for Jobs
     */
    'job' => [
        'listener_started'  => Listeners\Job\JobStartedListener::class,
        'listener_finished' => Listeners\Job\JobFinishedListener::class,
        'span_name'         => Configurations\Job\SpanNameResolver::class,
        'tags'              => Configurations\Job\TagsResolver::class,
    ],

    /**
     * Describes configuration for Job Dispatcher
     */
    'dispatcher' => [
        'span_name' => Configurations\JobDispatcher\SpanNameResolver::class,
        'tags'      => Configurations\JobDispatcher\TagsResolver::class,
    ],

    /**
     * Describes words that their value must be filtered
     */
    'filter_words' => ['username', 'password'],
];
