<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Http;

use Illuminate\Http\Request;
use Iranserver\LaravelJaeger\Traits\JaegerFunctions;
use Symfony\Component\HttpFoundation\Response;

final class TagsResolver
{
    use JaegerFunctions;

    public function __invoke(Request $request, Response $response): array
    {
        $request = $this->filterWordsInRequest($request);
        return [
            'type'         => 'route',
            'route.host'   => $request->getHost(),
            'route.path'   => '/' . trim(trim($request->path()), '/'),
            'route.method' => $request->method(),
            'route.body'   => $this->jsonEncode($request->all()),
            'route.status' => $response->getStatusCode(),
            'route.error'  => !$response->isSuccessful() && !$response->isRedirection(),
            'route.env'    => env('APP_ENV'),
        ];
    }
}
