<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Middleware;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use OpenTracing\Reference;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;
use Iranserver\LaravelJaeger\Services\TraceIdHeaderRetriever;

class JobTracingMiddleware
{
    public const JOB_TRACING_CONTEXT_FIELD = 'tracingContext';

    private $tracer;
    private $spanCreator;
    private $traceIdHeaderRetriever;

    public function __construct(Tracer $tracer, SpanCreator $spanCreator, TraceIdHeaderRetriever $traceIdHeaderRetriever)
    {
        $this->tracer = $tracer;
        $this->spanCreator = $spanCreator;
        $this->traceIdHeaderRetriever = $traceIdHeaderRetriever;
    }

    public function handle($job, callable $next)
    {
        $payload = $job->{self::JOB_TRACING_CONTEXT_FIELD} ?? [];

        $traceIdHeader = $this->traceIdHeaderRetriever->retrieve($payload);

        $span = $this->spanCreator->create(
            Caller::call(Config::get('jaeger.job.span_name'), [$job, $job->job ?? null]),
            $traceIdHeader,
            Reference::CHILD_OF
        );

        $callableConfig = Config::get('jaeger.job.tags', function () {
            return [
                'type' => 'job',
            ];
        });

        SpanTagHelper::setTags($span, Caller::call($callableConfig, [$job, $job->job ?? null]));

        $next($job);
    }
}
