<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Query;

use Illuminate\Database\Events\QueryExecuted;

final class SpanNameResolver
{
    public function __invoke(QueryExecuted $event): string
    {
        $fullSql = $event->sql;
        foreach ($event->bindings as $binding) {
            $fullSql = preg_replace('/\?/', json_encode($binding, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE), $fullSql, 1);
        }
        return '[Query] ' . ($event->time ? '[' . round($event->time / 1000.0, 5) . '] ' : '') . $fullSql;
    }
}
