<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services\Job;

use Illuminate\Contracts\Bus\QueueingDispatcher;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;

class JobWithTracingInjectionDispatcher implements QueueingDispatcher
{
    private $dispatcher;
    private $injectionMaker;

    public function __construct(QueueingDispatcher $dispatcher, JobInjectionMaker $injectionMaker)
    {
        $this->dispatcher = $dispatcher;
        $this->injectionMaker = $injectionMaker;
    }

    /**
     * @throws CallerException
     */
    public function dispatchNow($command, $handler = null)
    {
        return $this->dispatcher->dispatchNow($this->injectionMaker->injectParentSpanToCommand($command, 'Dispatch Now'), $handler);
    }

    /**
     * @throws CallerException
     */
    public function dispatchToQueue($command)
    {
        return $this->dispatcher->dispatchToQueue($this->injectionMaker->injectParentSpanToCommand($command, 'Dispatch To Queue'));
    }

    /**
     * @throws CallerException
     */
    public function dispatch($command)
    {
        return $this->dispatcher->dispatch($this->injectionMaker->injectParentSpanToCommand($command, 'Dispatch'));
    }

    /**
     * @throws CallerException
     */
    public function dispatchSync($command, $handler = null)
    {
        return $this->dispatcher->dispatchSync($this->injectionMaker->injectParentSpanToCommand($command, 'Dispatch Sync'));
    }

    public function hasCommandHandler($command)
    {
        return $this->dispatcher->hasCommandHandler($command);
    }

    public function getCommandHandler($command)
    {
        return $this->dispatcher->getCommandHandler($command);
    }

    public function pipeThrough(array $pipes)
    {
        return $this->dispatcher->pipeThrough($pipes);
    }

    public function map(array $map)
    {
        return $this->dispatcher->map($map);
    }

    public function findBatch(string $batchId)
    {
        return $this->dispatcher->findBatch($batchId);
    }

    public function batch($jobs)
    {
        return $this->dispatcher->batch($jobs);
    }

    public function chain($jobs)
    {
        return $this->dispatcher->chain($jobs);
    }
}
