<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services;

use Illuminate\Support\Facades\App;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;

class Caller
{
    /**
     * @throws CallerException
     */
    public static function call($callable, array $params, $defaultValue = null)
    {
        if (is_null($callable)) {
            return $defaultValue;
        }

        if (is_callable($callable)) {
            return $callable(...$params);
        }

        if (is_string($callable)) {
            $callableObject = App::make($callable);

            return $callableObject(...$params);
        }

        throw new CallerException('Unexpected callable parameter');
    }
}
