<?php

namespace Iranserver\LaravelJaeger\Listeners\Query;

use Illuminate\Database\Events\QueryExecuted;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use Iranserver\LaravelJaeger\Services\Span\SpanTagHelper;
use OpenTracing\Reference;
use OpenTracing\Span;
use OpenTracing\Tracer;

final class QueryListener
{
    private $tracer;
    private $spanCreator;

    public function __construct(Tracer $tracer, SpanCreator $spanCreator)
    {
        $this->tracer = $tracer;
        $this->spanCreator = $spanCreator;
    }

    /**
     * @throws CallerException
     */
    public function handle(QueryExecuted $event): void
    {
        /** @var Span|null $parentSpan */
        $parentSpan = $this->tracer->getActiveSpan();

        $span = $this->spanCreator->create(
            Caller::call(ConfigRepository::get('jaeger.query.span_name'), [$event]),
            $parentSpan ? $parentSpan->getContext()->getSpanId() : null,
            Reference::CHILD_OF
        );

        SpanTagHelper::setTags(
            $span,
            Caller::call(ConfigRepository::get('jaeger.query.tags'), [$event])
        );

        optional($this->tracer->getScopeManager()->getActive())->close();
        $this->tracer->flush();
    }
}
