<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Query;

use Illuminate\Database\Events\QueryExecuted;

final class TagsResolver
{
    public function __invoke(QueryExecuted $event): array
    {
        $fullSql = $event->sql;
        foreach ($event->bindings as $binding) {
            $fullSql = preg_replace('/\?/', json_encode($binding, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE), $fullSql, 1);
        }
        return [
            'type'                  => 'query',
            'query.sql'             => $event->sql,
            'query.sql_bindings'    => json_encode($event->bindings, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE),
            'query.sql_full'        => $fullSql,
            'query.connection_name' => $event->connectionName,
            'query.time'            => ($event->time ? round($event->time / 1000.0, 5) : null),
            'query.env'             => env('APP_ENV'),
        ];
    }
}
