<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Log;

use Illuminate\Log\Events\MessageLogged;

final class TagsResolver
{
    public function __invoke(MessageLogged $event): array
    {
        return [
            'type'        => 'log',
            'log.level'   => $event->level,
            'log.message' => $event->message,
            'log.context' => json_encode($event->context, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE),
            'log.env'     => env('APP_ENV'),
        ];
    }
}
