<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\JobDispatcher;

final class TagsResolver
{
    public function __invoke(object $command): array
    {
        return [
            'type'                   => 'dispatcher',
            'dispatcher.job_class'   => get_class($command),
            'dispatcher.job_payload' => json_encode((array)$command, JSON_OBJECT_AS_ARRAY | JSON_BIGINT_AS_STRING | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE),
            'dispatcher.env'         => env('APP_ENV'),
        ];
    }
}
