<?php

namespace Iranserver\LaravelJaeger\Configurations\Guzzle;

use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Http\Client\Factory;
use OpenTracing\Span;
use OpenTracing\Tracer;
use OpenTracing\Formats;

final class GuzzleHttpBinder
{
    public static function bind(Application $app): void
    {
        $app->bind(Factory::class, function () use ($app) {
            /** @var Tracer $tracer */
            $tracer = $app->make(Tracer::class);
            /** @var Dispatcher $dispatcher */
            $dispatcher = $app->make(Dispatcher::class);
            /** @var Span|null $parentSpan */
            $parentSpan = $tracer->getActiveSpan();
            $headers = [];
            if ($parentSpan !== null) {
                $tracer->inject($parentSpan->getContext(), Formats\TEXT_MAP, $headers);
            }
            return (new Factory($dispatcher))->withHeaders($headers);
        });
    }
}