<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Tests\Unit\Services;

use Orchestra\Testbench\TestCase;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Tests\Utils\InvokableStub;

class CallerTest extends TestCase
{
    public function testCallCallableWithParams(): void
    {
        $callable = function ($a) {
            return $a;
        };

        $result = Caller::call($callable, [100]);

        $this->assertSame(100, $result);
    }

    public function testCallInvokableWithParams(): void
    {
        $result = Caller::call(InvokableStub::class, [100]);

        $this->assertSame(100, $result);
    }

    public function testExceptionIfUnexpectedType(): void
    {
        $this->expectException(CallerException::class);
        Caller::call(null, []);
    }
}
