<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Configurations\Guzzle;

use Illuminate\Http\Client\Events\RequestSending;

final class TagsResolver
{
    public function __invoke(RequestSending $event): array
    {
        return [
            'type'          => 'guzzle',
            'guzzle.method' => $event->request->method(),
            'guzzle.url'    => $event->request->url(),
            'guzzle.body'   => $event->request->body(),
        ];
    }
}
