<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Listeners\Console;

use Illuminate\Console\Events\CommandStarting;
use Illuminate\Support\Facades\Config as ConfigRepository;
use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\ConsoleCommandFilter;
use Iranserver\LaravelJaeger\Services\Exceptions\CallerException;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use OpenTracing\Reference;
use OpenTracing\Span;
use OpenTracing\Tracer;

final class ConsoleCommandStartedListener
{
    private $tracer;
    private $spanCreator;

    public function __construct(Tracer $tracer, SpanCreator $spanCreator)
    {
        $this->tracer = $tracer;
        $this->spanCreator = $spanCreator;
    }

    /**
     * @throws CallerException
     */
    public function handle(CommandStarting $event): void
    {
        /** @var ConsoleCommandFilter $filter */
        $filter = app(ConsoleCommandFilter::class);
        if (!$filter->allow($event->command)) {
            return;
        }

        $traceIdHeader = '';
        if (!app()->runningInConsole()) {
            /** @var Span|null $parentSpan */
            $parentSpan = $this->tracer->getActiveSpan();
            $traceIdHeader = $parentSpan ? $parentSpan->getContext()->getSpanId() : '';
        }

        $this->spanCreator->create(
            Caller::call(ConfigRepository::get('jaeger.console.span_name'), [$event]),
            $traceIdHeader,
            Reference::CHILD_OF
        );
    }
}
