<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services\Job;

use Iranserver\LaravelJaeger\Services\Caller;
use Iranserver\LaravelJaeger\Services\Span\SpanCreator;
use OpenTracing\Formats;
use OpenTracing\Tracer;
use Iranserver\LaravelJaeger\Middleware\JobTracingMiddleware;
use Illuminate\Support\Facades\Config;
use OpenTracing\Reference;

class JobInjectionMaker
{
    private $tracer;
    private $spanCreator;

    public function __construct(Tracer $tracer, SpanCreator $spanCreator)
    {
        $this->tracer = $tracer;
        $this->spanCreator = $spanCreator;
    }

    public function injectParentSpanToCommand(object $command): object
    {
        $tracingContextField = JobTracingMiddleware::JOB_TRACING_CONTEXT_FIELD;

        if (!empty($command->{$tracingContextField})) {
            return $command;
        }

        $span = $this->tracer->getActiveSpan();

        if (!$span) {
            return $command;
        }

        $command->{$tracingContextField} = [];
        $this->tracer->inject($span->getContext(), Formats\TEXT_MAP, $command->{$tracingContextField});

        $this->spanCreator->create(
            Caller::call(Config::get('jaeger.dispatcher.span_name'), [$command]),
            $span->getContext()->getSpanId(),
            Reference::CHILD_OF
        );

        return $command;
    }
}
