<?php

declare(strict_types=1);

namespace Iranserver\LaravelJaeger\Services\Http;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Iranserver\LaravelJaeger\Services\Caller;

class TracingRequestGuard
{
    public function allowRequest(Request $request): bool
    {
        if (Config::get('jaeger.http.allow_request')) {
            if (!Caller::call(Config::get('jaeger.http.allow_request'), [$request])) {
                return false;
            }
        }

        if (Config::get('jaeger.http.deny_request')) {
            if (Caller::call(Config::get('jaeger.http.deny_request'), [$request])) {
                return false;
            }
        }

        return true;
    }
}
